from django.core.cache import cache
from .models import Car, Region

def global_datalists(request):
    cars = cache.get('cars_datalist')
    regions = cache.get('regions_datalist')

    if cars is None:
        cars = Car.objects.filter(is_active=True).order_by('plate_number')
        cache.set('cars_datalist', cars, 60 * 60)

    if regions is None:
        regions = Region.objects.filter(is_active=True).order_by('name')
        cache.set('regions_datalist', regions, 60 * 60)

    return {
        'cars_datalist': cars,
        'regions_datalist': regions,
    }
