# Generated by Django 5.1.5 on 2025-11-14 22:56

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='DrinksStore',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('soda_store', models.IntegerField(default=0)),
                ('water_store', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Statistics',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('trip_date', models.DateField(default=django.utils.timezone.now)),
                ('car_id', models.CharField(default='T 884DEE', max_length=10)),
                ('start', models.CharField(max_length=255)),
                ('destination', models.CharField(max_length=255)),
                ('passenger_number', models.IntegerField()),
                ('return_trip_date', models.DateField(default=django.utils.timezone.now)),
                ('return_start', models.CharField(default='none', max_length=255)),
                ('return_destination', models.CharField(default='none', max_length=255)),
                ('return_passenger_number', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(max_length=20)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('car_id', models.CharField(default='T 884DEE', max_length=10)),
                ('transaction_type', models.CharField(choices=[('add', 'Add'), ('take', 'Take')], max_length=10)),
                ('soda_amount', models.IntegerField(default=0)),
                ('water_amount', models.IntegerField(default=0)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('declined', 'Declined')], default='pending', max_length=10)),
                ('created_at', models.TimeField(auto_now_add=True)),
                ('created_on', models.DateField(auto_now_add=True)),
                ('confirmed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='confirmed_transactions', to=settings.AUTH_USER_MODEL)),
                ('tripstatics', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='transactions', to='main.statistics')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
