# main/signals.py
from django.db.models.signals import post_save, post_delete
from django.dispatch import receiver
from django.core.cache import cache
from .models import Car, Region

@receiver([post_save, post_delete], sender=Car)
def clear_car_cache(sender, **kwargs):
    cache.delete('cars_datalist')

@receiver([post_save, post_delete], sender=Region)
def clear_region_cache(sender, **kwargs):
    cache.delete('regions_datalist')
